@extends('layouts.admin')

@section('title', 'Appointment Details')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Appointment Details</h1>
    <a href="{{ route('admin.appointments.index') }}" class="btn btn-secondary">
        <i class="bi bi-arrow-left"></i> Back
    </a>
</div>

<div class="row g-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Patient Information</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="200">Name:</th>
                        <td>{{ $appointment->name }}</td>
                    </tr>
                    <tr>
                        <th>Age:</th>
                        <td>{{ $appointment->age }} years</td>
                    </tr>
                    <tr>
                        <th>Email:</th>
                        <td><a href="mailto:{{ $appointment->email }}">{{ $appointment->email }}</a></td>
                    </tr>
                    <tr>
                        <th>Phone:</th>
                        <td><a href="tel:{{ $appointment->phone }}">{{ $appointment->phone }}</a></td>
                    </tr>
                    <tr>
                        <th>Preferred Time:</th>
                        <td>{{ $appointment->preferred_time->format('F d, Y h:i A') }}</td>
                    </tr>
                    <tr>
                        <th>Selected Doctor:</th>
                        <td>{{ $appointment->doctor ? $appointment->doctor->name . ' - ' . $appointment->doctor->specialization : 'Any Doctor' }}</td>
                    </tr>
                    @if($appointment->message)
                    <tr>
                        <th>Message:</th>
                        <td>{{ $appointment->message }}</td>
                    </tr>
                    @endif
                </table>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Status</h5>
            </div>
            <div class="card-body">
                <p>
                    <span class="badge bg-{{ $appointment->status == 'pending' ? 'warning' : ($appointment->status == 'confirmed' ? 'success' : 'danger') }} fs-6">
                        {{ ucfirst($appointment->status) }}
                    </span>
                </p>
                <p class="text-muted small mb-0">
                    <strong>Submitted:</strong><br>
                    {{ $appointment->created_at->format('F d, Y h:i A') }}
                </p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">Update Status</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.appointments.updateStatus', $appointment) }}" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="mb-3">
                        <select name="status" class="form-select" required>
                            <option value="pending" {{ $appointment->status == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="confirmed" {{ $appointment->status == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                            <option value="cancelled" {{ $appointment->status == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">Update Status</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection



